<#
.SYNOPSIS
  Powershell script to get information from microsoft endpoint manager and represent in prtg
.NOTES
  Version:        1.0
  Author:         roman huesler / opensight.ch
  Creation Date:  02.05.2021
  Purpose/Change: Initial script development 
.EXAMPLE
  Powershell Script - Endpoint Manager Status -username -password
#>

#authentication
param(
    [string]$username,
    [String]$password
)


$secureStringPwd = $password | ConvertTo-SecureString -AsPlainText -Force
$credentials = New-Object ('System.Management.Automation.PSCredential') -ArgumentList $username, $secureStringPwd

#############################################################################
#If Powershell is running the 32-bit version on a 64-bit machine, we 
#need to force powershell to run in 64-bit mode .
#http://cosmonautdreams.com/2013/09/03/Getting-Powershell-to-run-in-64-bit.html
#############################################################################
if ($env:PROCESSOR_ARCHITEW6432 -eq "AMD64") {
    write-warning "Y'arg Matey, we're off to 64-bit land....."
    if ($myInvocation.Line) {
        &"$env:WINDIR\sysnative\windowspowershell\v1.0\powershell.exe" -NonInteractive -NoProfile $myInvocation.Line
    }else{
        &"$env:WINDIR\sysnative\windowspowershell\v1.0\powershell.exe" -NonInteractive -NoProfile -file "$($myInvocation.InvocationName)" $args
    }
exit $lastexitcode
}

#connect to msgraph
Connect-MSGraph -PSCredential $credentials

# get endpoint information
$all_devices = (Get-IntuneManagedDevice).Count
$oswindows = (Get-IntuneManagedDevice | Where-Object {$_.operatingSystem -eq "Windows"}).Count
$osmacos = (Get-IntuneManagedDevice | Where-Object {$_.operatingSystem -eq "MacOS"}).Count
$osandroid = (Get-IntuneManagedDevice | Where-Object {$_.operatingSystem -eq "Android"}).Count
$osiphone = (Get-IntuneManagedDevice | Where-Object {$_.operatingSystem -eq "iOS"}).Count
$osunknown = (Get-IntuneManagedDevice | Where-Object {$_.operatingSystem -eq ""}).Count
$compliant = (Get-IntuneManagedDevice | Where-Object {$_.complianceState -ne "compliant"}).Count
$isencrypted = (Get-IntuneManagedDevice | Where-Object {$_.isEncrypted -ne "True"}).Count

#returning PRTG XML data
#https://www.paessler.com/manuals/prtg/custom_sensors
"<prtg>"
"<result>"
"<channel>Total Devices</channel>"
"<value>$all_devices</value>"
"</result>"
"<result>"
"<channel>Windows</channel>"
"<value>$oswindows</value>"
"</result>"
"<result>"
"<channel>MacOS</channel>"
"<value>$osmacos</value>"
"</result>"
"<result>"
"<channel>Android</channel>"
"<value>$osandroid</value>"
"</result>"
"<result>"
"<channel>iPhone</channel>"
"<value>$osiphone</value>"
"</result>"
"<result>"
"<channel>Unknown</channel>"
"<value>$osunknown</value>"
"</result>"
"<result>"
"<channel>Not Compliant</channel>"
"<value>$compliant</value>"
"</result>"
"<result>"
"<channel>Not Encrypted</channel>"
"<value>$isencrypted</value>"
"</result>"
"</prtg>"