=== Drew's Simple Internal Linking ===
Contributors: discodrew
Tags: internal linking, seo, links, automation
Requires at least: 5.0
Tested up to: 6.8
Stable tag: 1.0.2
Requires PHP: 7.4
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Automatically converts plain text to internal links throughout your WordPress posts and pages.

## Features

- **Simple Interface**: Clean, user-friendly admin interface in the Appearance menu
- **Flexible Scope**: Apply linking rules to pages only, posts only, or both
- **Case Insensitive**: Automatically handles text regardless of case (e.g., "Drew Chapin" and "drew chapin")
- **Progress Tracking**: Real-time progress indicators for all operations
- **Dashboard Management**: View, re-run, and remove all internal linking rules
- **Confirmation Dialogs**: Safety prompts before making changes
- **AJAX Powered**: Smooth, responsive user experience

## Installation

1. Upload the plugin files to your `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to **Appearance > Internal Linking** to access the dashboard

## Usage

### Creating a New Internal Link

1. Go to **Appearance > Internal Linking**
2. Fill in the form:
   - **Anchor Text**: The text you want to convert to a link (e.g., "Drew Chapin")
   - **Target URL**: The destination URL (e.g., "https://chapin.io")
   - **Scope**: Choose whether to apply to pages, posts, or both
3. Click the green "Create Internal Link" button
4. Confirm the action in the dialog
5. Monitor progress as the plugin processes your content

### Managing Existing Links

The dashboard displays all your internal linking rules with:
- **Anchor Text**: The text being linked
- **Target URL**: Where the links point to
- **Scope**: Where the rule is applied
- **Created**: When the rule was created
- **Last Run**: When it was last applied
- **Actions**: Re-run or remove the rule

### Re-running Links

Use the blue "Re-run" button to re-apply a linking rule. This is useful when:
- You've added new content
- Content has been modified
- You want to ensure all instances are properly linked

### Removing Links

Use the red "Remove" button to delete a linking rule. This will:
- Remove the rule from the database
- Convert all linked instances back to plain text
- Update the dashboard

## Technical Details

- **Database Table**: Creates `wp_drew_internal_links` table on activation
- **Content Processing**: Only processes post/page content (not titles, excerpts, or widgets)
- **Link Replacement**: Uses case-insensitive regex patterns for accurate text matching
- **Progress Tracking**: Uses WordPress transients for real-time progress updates
- **Security**: Includes nonce verification and capability checks

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- MySQL 5.6 or higher

## Roadmap Features

The following features are planned for future versions:

### Link Attributes
- `target="_blank"` for external links
- `rel="nofollow"` and other SEO attributes
- Custom CSS classes for styling
- Link title attributes

### Enhanced Content Support
- Widget text support
- Custom post type support
- Comment content support
- Custom fields support

### Advanced Options
- Bulk import/export of linking rules
- Scheduled linking operations
- Link analytics and reporting
- A/B testing for link placement

### Performance Improvements
- Background processing for large sites
- Caching mechanisms
- Database optimization
- Batch processing options

## Support

For support, feature requests, or bug reports, please visit [https://chapin.io/drews-simple-internal-linking-wordpress-plugin/](https://chapin.io/drews-simple-internal-linking-wordpress-plugin/) or contact the plugin author.

## Changelog

### Version 1.0.2
- Initial release
- Basic internal linking functionality
- Admin dashboard
- Progress tracking
- Re-run and remove capabilities

## License

This plugin is licensed under the GPL v2 or later.

## Credits

Developed by Drew Chapin - [chapin.io](https://chapin.io)
