<div class="wrap">
    <h1>Drew's Simple Internal Linking</h1>
    
    <div class="drews-il-container">
        <!-- Create New Link Form -->
        <div class="drews-il-form-section">
            <h2>Create New Internal Link</h2>
                            <form id="drews-il-form" class="drews-il-form">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="anchor_text">Anchor Text</label>
                        </th>
                        <td>
                            <input type="text" id="anchor_text" name="anchor_text" class="regular-text" 
                                   placeholder="e.g., Drew Chapin" required>
                            <p class="description">The text that will be converted to a link throughout your site.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="target_url">Target URL</label>
                        </th>
                        <td>
                            <input type="url" id="target_url" name="target_url" class="regular-text" 
                                   placeholder="https://example.com" required>
                            <p class="description">The URL where the anchor text should link to.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="scope">Apply to</label>
                        </th>
                        <td>
                            <select id="scope" name="scope">
                                <option value="both">Pages and Posts</option>
                                <option value="pages">Pages Only</option>
                                <option value="posts">Posts Only</option>
                            </select>
                            <p class="description">Choose where to apply this internal linking rule.</p>
                        </td>
                    </tr>
                </table>
                
                <div class="drews-il-form-actions">
                    <button type="submit" class="button button-primary button-large drews-il-submit">
                        <span class="button-text">Create Internal Link</span>
                        <span class="spinner" style="display: none;"></span>
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Progress Bar -->
        <div id="drews-il-progress" class="drews-il-progress" style="display: none;">
            <div class="drews-il-progress-bar">
                <div class="drews-il-progress-fill"></div>
            </div>
            <div class="drews-il-progress-text">Processing...</div>
        </div>
        
        <!-- Dashboard -->
                    <div class="drews-il-dashboard-section">
            <h2>Internal Linking Dashboard</h2>
            
            <?php if (empty($links)): ?>
                <div class="drews-il-empty-state">
                    <p>No internal linking rules created yet. Create your first one above!</p>
                </div>
            <?php else: ?>
                <div class="drews-il-table-container">
                    <table class="wp-list-table widefat fixed striped">
                        <thead>
                            <tr>
                                <th>Anchor Text</th>
                                <th>Target URL</th>
                                <th>Scope</th>
                                <th>Created</th>
                                <th>Last Run</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($links as $link): ?>
                                <tr data-link-id="<?php echo esc_attr($link->id); ?>">
                                    <td>
                                        <strong><?php echo esc_html($link->anchor_text); ?></strong>
                                    </td>
                                    <td>
                                        <a href="<?php echo esc_url($link->target_url); ?>" target="_blank">
                                            <?php echo esc_html($link->target_url); ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php 
                                        $scope_labels = array(
                                            'both' => 'Pages & Posts',
                                            'pages' => 'Pages Only',
                                            'posts' => 'Posts Only'
                                        );
                                        echo esc_html($scope_labels[$link->scope] ?? $link->scope);
                                        ?>
                                    </td>
                                    <td>
                                        <?php echo esc_html(gmdate('M j, Y', strtotime($link->created_at))); ?>
                                    </td>
                                    <td>
                                        <?php echo esc_html(gmdate('M j, Y', strtotime($link->last_run))); ?>
                                    </td>
                                    <td>
                                                                                    <div class="drews-il-actions">
                                            <button class="button button-secondary drews-il-re-run" 
                                                    data-link-id="<?php echo esc_attr($link->id); ?>"
                                                    title="Re-apply this linking rule">
                                                <span class="dashicons dashicons-update"></span>
                                                Re-run
                                            </button>
                                            <button class="button button-link-delete drews-il-remove" 
                                                    data-link-id="<?php echo esc_attr($link->id); ?>"
                                                    title="Remove this linking rule">
                                                <span class="dashicons dashicons-trash"></span>
                                                Remove
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Confirmation Modal -->
    <div id="drews-il-modal" class="drews-il-modal" style="display: none;">
            <div class="drews-il-modal-content">
            <div class="drews-il-modal-header">
                <h3 id="drews-il-modal-title">Confirm Action</h3>
            </div>
            <div class="drews-il-modal-body">
                <p id="drews-il-modal-message"></p>
            </div>
            <div class="drews-il-modal-footer">
                <button type="button" class="button button-secondary" id="drews-il-modal-cancel">Cancel</button>
                <button type="button" class="button button-primary" id="drews-il-modal-confirm">Confirm</button>
            </div>
        </div>
</div>
