# Release Notes - Version 1.0.3

## Major Update - Divi Compatibility & Emergency Tools

This is a significant update that addresses Divi theme compatibility issues and adds powerful emergency tools for content management.

## 🚨 Important: Breaking Changes Fixed

- **Fixed content corruption with Divi theme** - The plugin now safely handles Divi's complex shortcode structure
- **Resolved malformed HTML generation** - Improved regex patterns prevent broken anchor tags
- **Enhanced content validation** - Multiple safety checks prevent content corruption

## ✨ New Features

### Emergency Tools
- **Bulk Find & Replace Tool** - Clean up malformed links and fix content issues across all posts
- **Preview Mode** - See exactly what will change before applying fixes
- **Divi-Safe Mode** - Automatically skips Divi-heavy content to prevent further issues

### Revert Functionality
- **One-Click Revert** - Each linking rule now has a revert button to undo all changes
- **Automatic Backups** - The plugin creates backups before making any changes
- **Safe Restoration** - Restore content to its original state with confidence

### Divi Theme Compatibility
- **Divi Detection** - Automatically identifies and skips posts with heavy Divi shortcode usage
- **Content Validation** - Ensures changes won't break Divi's nested structure
- **Shortcode Protection** - Preserves Divi shortcodes during content modification
- **Safe Processing** - Multiple layers of protection for Divi content

## 🔧 Improvements

- **Enhanced Content Processing** - Better handling of complex content structures
- **Improved Error Handling** - More informative error messages and user feedback
- **Better Progress Tracking** - Real-time updates during bulk operations
- **Content Safety Checks** - Prevents malformed HTML and broken shortcodes

## 🐛 Bug Fixes

- Fixed content corruption issues with Divi theme
- Resolved malformed HTML generation (broken anchor tags like `">text`)
- Improved regex patterns for better accuracy
- Enhanced shortcode protection
- Fixed issues with nested HTML content

## 📋 Technical Changes

- Added `wp_drew_internal_links_backup` database table for content backups
- Implemented Divi shortcode detection algorithms
- Added content validation system
- Enhanced regex patterns for safer content processing
- Improved AJAX error handling

## 🎯 For Users Experiencing Issues

If you're experiencing issues with malformed links:

1. **Update to version 1.0.3**
2. Go to **Appearance → Internal Linking**
3. Scroll to the bottom and click **"Bulk Find and Replace"**
4. Use the pre-built patterns to fix common issues
5. Preview changes before applying

## 🔄 Migration Notes

- **Automatic Database Updates** - The plugin will automatically create the backup table
- **No Data Loss** - All existing linking rules are preserved
- **Backward Compatible** - Works with existing installations

## 📞 Support

If you encounter any issues with this update, please contact support immediately. This update specifically addresses content corruption issues and should resolve the problems you may have experienced.

---

**Version**: 1.0.3  
**Release Date**: September 5, 2025  
**Compatibility**: WordPress 5.0+, PHP 7.4+, Divi Theme
