<?php
/**
 * Uninstall file for Drew's Simple Internal Linking
 * 
 * This file is executed when the plugin is deleted through the WordPress admin.
 * It removes all plugin data from the database.
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Note: Direct database calls are necessary and acceptable in uninstall.php
// WordPress caching may not be available during plugin removal
// This is standard practice for cleanup operations

// Remove the database table
global $wpdb;
$table_name = $wpdb->prefix . 'drews_internal_links';

$wpdb->query("DROP TABLE IF EXISTS `{$wpdb->prefix}drews_internal_links`");

// Clean up any transients that might be left
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
        '_transient_drews_il_progress_%'
    )
);

$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
        '_transient_timeout_drews_il_progress_%'
    )
);
