/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./resources/**/*.{php,html,js,jsx,ts,tsx,vue}",
    "./node_modules/flowbite/**/*.js"
  ],
  theme: {
    fontFamily: {
      sans: ['Poppins', 'sans-serif'],
      'Poppins': ['Poppins', 'sans-serif'],
    },
    extend: {
      colors: {
        "body-blue": "#EEF8FA",
        "dark-blue": "#0F1729",
        "blue-1200": "#0172B1",
        "blue-1300": "#8280FF",
        "red-1200": "#C9020E",
        "light-red-1200": "#FFEFEF",
        "black-1200": "#202224",
        "gray-1200": "#DBDBDB",
        "orange-bg-1200": "#FEC53D",
        "green-1200": "#4CAF50",
      },
      height: {
        '41': '41px',
        'small4': '4.88px',
        '266': '266px',
      },
      width: {
        '41': '41px',
        'small4': '4.88px',
      },
      padding: {
        '21': '21px',
        '60': '60px',
        '70': '70px',
      },
      letterSpacing: {
        'default': '0.26px',
        '0.7': '0.27px',
        '0.3': '0.3px',
        '0.24': '0.24px',
        '1': '1px',
        '0.06': '-0.06px',
        '32p': '0.32px',
        '39': '0.39px',
      },
      maxWidth: {
        '11xl': '249px', 
      },
      brightness: {
        '180': '18605%', 
      },
      boxShadow: {
        '3xl': '6px 6px 54px 0px rgba(0,0,0,0.05)', 
        '4xl': '0px 20px 50px 0px rgba(55,69,87,0.1)', 
        '5xl': '0px 6px 20px 0px rgba(0,0,0,0.20)', 
      },
      borderRadius: {
        '14': '14px', 
      },
      fontSize: {
        '22': '22px', 
      },
      margin: {
        '28': '28px',
      }
    },
  },
  plugins: [
    require("flowbite/plugin"),
  ],
};
