# ESP Sleek Theme Implementation Plan

## Overview
The ESP Sleek theme will be a modern, clean implementation based on the new design from esp_frontend_new while maintaining all existing functionality from esp_theme.

## Theme Architecture

### 1. Directory Structure
```
themes/ep/esp_sleek/
├── composer.json                    # Theme metadata
├── lang/                           # Language files
│   └── en/
├── public/                         # Public assets (compiled)
│   ├── css/
│   │   └── app.css
│   ├── img/                       # Theme images
│   ├── js/
│   │   └── app.js
│   └── screenshot.png
└── resources/
    ├── css/
    │   ├── esp_sleek.css          # Main theme styles
    │   └── tailwind.config.js     # Tailwind configuration
    ├── js/
    │   ├── esp_theme.js           # Main JS (from esp_theme)
    │   └── google-maps.js         # Maps (from esp_theme)
    └── views/
        ├── layouts/               # Page layouts
        ├── components/            # Blade components
        ├── livewire/             # Livewire components
        └── pages/                # Page templates
```

### 2. Key Design Changes from esp_frontend_new

#### Color Palette
- Primary Blue: `#335cff`
- Mid Gray: `#525866`
- Gray variations: `#e1e4ea`, `#f5f7fa`, `#99A0AE`, `#CACFD8`
- Black variations: `#0e121b`, `#222530`
- Blue variations: `#ebf1ff`, `#1f3bad`, `#476cff`, `#2547d0`

#### Typography
- Font: Inter (from Google Fonts)
- Clean, modern typography with proper tracking

#### Shadows
- Multiple shadow levels for depth (shadow-3xl to shadow-10xl)
- Subtle, professional appearance

#### Components
- Rounded corners (rounded-full, rounded-2xl, rounded-xl)
- Clean card designs with borders
- Modern button styles (primary-btn, secondary-btn)
- Tag system with hover effects
- Responsive grid layouts

### 3. Blade Component Structure

```
components/
├── frontend/
│   ├── common/
│   │   ├── header.blade.php          # Site header
│   │   ├── footer.blade.php          # Site footer
│   │   ├── breadcrumb.blade.php      # Breadcrumb nav
│   │   ├── button.blade.php          # Button component
│   │   ├── tag.blade.php             # Tag component
│   │   └── card.blade.php            # Card wrapper
│   ├── member/
│   │   ├── profile-header.blade.php  # Member profile header
│   │   ├── profile-tabs.blade.php    # Tab navigation
│   │   ├── contact-card.blade.php    # Contact info card
│   │   ├── gallery.blade.php         # Image gallery
│   │   ├── search-card.blade.php     # Search result card
│   │   └── featured-card.blade.php   # Featured member card
│   ├── blog/
│   │   ├── article-card.blade.php
│   │   └── article-detail.blade.php
│   ├── classified/
│   │   ├── listing-card.blade.php
│   │   └── listing-detail.blade.php
│   ├── equipment/
│   │   ├── equipment-card.blade.php
│   │   └── equipment-detail.blade.php
│   ├── job/
│   │   ├── job-card.blade.php
│   │   └── job-detail.blade.php
│   └── project/
│       ├── project-card.blade.php
│       └── project-detail.blade.php
```

### 4. Livewire Component Structure

```
livewire/
├── frontend/
│   ├── member/
│   │   ├── member-search.blade.php       # Search functionality
│   │   ├── member-list.blade.php         # List view
│   │   ├── member-map.blade.php          # Map view
│   │   └── member-filter.blade.php       # Search filters
│   ├── blog/
│   │   └── post-list.blade.php
│   ├── classified/
│   │   ├── classified-list.blade.php
│   │   └── classified-search.blade.php
│   ├── equipment/
│   │   └── equipment-list.blade.php
│   ├── job/
│   │   ├── job-list.blade.php
│   │   └── job-apply.blade.php
│   └── project/
│       └── project-list.blade.php
```

### 5. Page Templates Structure

```
pages/
├── home.blade.php                    # Homepage
├── member/
│   ├── index.blade.php              # Member directory
│   ├── profile.blade.php            # Member profile
│   ├── search-list.blade.php        # Search results list
│   └── search-map.blade.php         # Search results map
├── blog/
│   ├── index.blade.php
│   └── show.blade.php
├── classified/
│   ├── index.blade.php
│   └── show.blade.php
├── equipment/
│   ├── index.blade.php
│   └── show.blade.php
├── job/
│   ├── index.blade.php
│   └── show.blade.php
└── project/
    ├── index.blade.php
    └── show.blade.php
```

### 6. JavaScript Integration

All JavaScript functionality from esp_theme will be preserved:
- Swiper.js for carousels
- LightGallery for image galleries
- Google Maps for location features
- Alpine.js for reactive UI
- Livewire integration
- Custom functionality (share modals, copy to clipboard, etc.)

### 7. CSS Architecture

```css
/* esp_sleek.css structure */
@import url('https://fonts.googleapis.com/css2?family=Inter...');
@import "tailwindcss";

/* Theme configuration */
@theme {
    /* Color palette */
    /* Shadows */
    /* Breakpoints */
}

/* Component styles */
.tags { }
.primary-btn { }
.secondary-btn { }
.readmore-btn { }
.view-btn { }

/* Utility classes */
/* Responsive adjustments */
```

### 8. Implementation Steps

1. **Phase 1: Setup**
   - Create theme folder structure
   - Setup composer.json
   - Configure Tailwind CSS
   - Copy JavaScript files from esp_theme

2. **Phase 2: Base Templates**
   - Create base layouts
   - Implement header/footer components
   - Setup navigation components

3. **Phase 3: Component Migration**
   - Convert HTML from esp_frontend_new to Blade components
   - Maintain existing Livewire integration
   - Ensure all functionality is preserved

4. **Phase 4: Page Templates**
   - Implement all page templates
   - Integrate with existing controllers
   - Test with existing routes

5. **Phase 5: Testing & Optimization**
   - Test all functionality
   - Optimize assets
   - Ensure responsive design
   - Verify Livewire components work correctly

## Key Considerations

1. **Backward Compatibility**: All existing functionality must work
2. **Performance**: Optimize assets and lazy load where possible
3. **Accessibility**: Ensure WCAG compliance
4. **SEO**: Maintain existing SEO features
5. **Mobile First**: Design for mobile devices first
6. **Browser Support**: Support modern browsers

## Dependencies

- Laravel 12
- Livewire 3.5
- Alpine.js
- Tailwind CSS
- Swiper.js
- LightGallery
- Google Maps API
- Flowbite (for UI components)

## Notes

- The theme will use the existing backend structure
- No changes to controllers, models, or routes
- Focus only on the presentation layer
- Maintain all existing integrations