# GEMINI.md

## Project Overview

This is a full-stack Laravel 12 application named "ESP". It features a dynamic theming system, a dynamic page builder, and several modules including a blog, member directory, project showcase, classifieds, job board, and equipment listing. The application is built with a modern tech stack, including:

*   **Backend:** PHP 8.2+, Laravel 12, Filament 3 (for the admin panel), Livewire 3, Laravel Cashier (for Stripe payments), and PayPal. It also utilizes several Spatie packages for media handling, permissions, and auditing.
*   **Frontend:** Vite for asset bundling, Tailwind CSS for styling (with DaisyUI and Flowbite component libraries), and a variety of JavaScript libraries for rich user interactions, including Swiper.js, Lightgallery.js, Quill.js, and TinyMCE.
*   **Database:** The application uses a relational database, likely MySQL or MariaDB, and leverages Laravel's Eloquent ORM.

The application's configuration is dynamic, with many settings stored in the database and loaded at runtime via the `DynamicConfigServiceProvider`. This allows for easy management of the application's settings without modifying `.env` files.

## Building and Running

To get the application up and running for development, follow these steps:

1.  **Install Dependencies:**
    *   Install PHP dependencies: `composer install`
    *   Install Node.js dependencies: `npm install`

2.  **Set up Environment:**
    *   Copy the `.env.example` file to `.env`: `cp .env.example .env`
    *   Generate an application key: `php artisan key:generate`
    *   Configure your database and other environment variables in the `.env` file.

3.  **Run Migrations and Seeders:**
    *   Run database migrations: `php artisan migrate`
    *   (Optional) Run database seeders to populate the database with sample data: `php artisan db:seed`

4.  **Run the Development Server:**
    *   The recommended way to run the development server is to use the `dev` script in `composer.json`:
        ```bash
        composer run dev
        ```
    *   This command will concurrently run the PHP development server, a queue listener, the log viewer, and the Vite development server.

## Development Conventions

*   **Theming:** The application uses the `hexadog/laravel-themes-manager` package for theming. The active theme is set in the `.env` file with the `ACTIVE_THEME` variable.
*   **Dynamic Pages:** The application has a dynamic page creation system. Pages are stored in the `pages` table and rendered using the `TemplateController`.
*   **Admin Panel:** The admin panel is built with Filament. You can access it at `/admin`.
*   **Code Style:** The project uses Laravel Pint for code styling. You can run it with `./vendor/bin/pint`.
*   **Authentication:** Authentication is handled by Livewire components.
*   **Service-Oriented Architecture:** The codebase is organized into controllers, services, and repositories, promoting a clean and maintainable architecture.
