<?php

namespace App\Auditing\Modifiers;

use App\Models\User\User;
use OwenIt\Auditing\Contracts\AttributeRedactor;

class CreatedByModifier implements AttributeRedactor
{
    /**
     * Redact an attribute value.
     *
     * @param mixed $value
     *
     * @return string
     */
    public static function redact($value): string
    {
        if (!empty($value)) {
            $user = User::find($value);
            if ($user) {
                return $user->name;
            }
        }
        return (string) $value;
    }
} 