<?php

namespace App\Auditing\Modifiers;

use Illuminate\Support\Str;
use OwenIt\Auditing\Contracts\AttributeRedactor;

class PostDescriptionModifier implements AttributeRedactor
{
    /**
     * Redact an attribute value.
     *
     * @param mixed $value
     *
     * @return string
     */
    public static function redact($value): string
    {
        if (empty($value)) {
            return '';
        }

        // Convert to text and show just a brief excerpt
        // $text = tiptap_converter()->asText($value);
        $text = $value;
        return Str::limit($text, 50);
    }
}
