<?php

namespace App\Console\Commands;

use App\Models\Blog\Post;
use App\Models\Blog\PostCategory;
use Illuminate\Console\Command;

class AttachPostCategories extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'posts:attach-categories';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Attach random child categories to posts, removing previous attachments.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Attaching child categories to posts...');

        $posts = Post::all();
        $categories = PostCategory::whereNotNull('parent_id')->get();

        if ($categories->isEmpty()) {
            $this->error('No child post categories found. Please create some child categories first.');
            return;
        }

        foreach ($posts as $post) {
            // Detach all existing categories
            $post->categories()->detach();

            // Get a random number of categories to attach (1 to 3)
            $numberOfCategories = rand(1, min(3, $categories->count()));
            
            // Get random categories
            $randomCategories = $categories->random($numberOfCategories);

            // Attach the new categories
            $post->categories()->attach($randomCategories->pluck('id'));
        }

        $this->info('Child categories attached to posts successfully!');
    }
}
