<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Membership\Purchase;
use App\Enums\PurchaseItemType;
use Illuminate\Support\Str;

class CreatePurchases extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:create-purchases';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting purchase creation...');

        $purchase = new Purchase();

        for ($i = 0; $i < 100; $i++) {
            $purchase->user_id = 1; 
            $purchase->item_type = PurchaseItemType::Subscription;
            $purchase->purchaseable_type = null;
            $purchase->purchaseable_id = null;
            $purchase->amount = 100;
            $purchase->currency = 'USD';
            $purchase->quantity = 1;
            $purchase->total_amount = 100;
            $purchase->tax_amount = 0;
            $purchase->notes = 'Purchase ' . $i + 1;
            $purchase->purchase_date = now();
            $purchase->created_by = 1;
            $purchase->save();
        }
        

        $this->info('Purchase creation completed.');
    }
}
