<?php

namespace App\Console\Commands;

use App\Services\Settings\SettingsManager;
use Illuminate\Console\Command;

class SeedDefaultSettings extends Command
{
    protected $signature = 'settings:seed';
    protected $description = 'Seed default settings from configuration';

    public function handle(SettingsManager $settings)
    {
        $this->info('Seeding default settings...');

        $config = config('settings.groups');
        $count = 0;

        foreach ($config as $groupKey => $group) {
            $groupId = $group['id'] ?? $groupKey;

            foreach ($group['sections'] ?? [] as $sectionKey => $section) {
                foreach ($section['fields'] ?? [] as $field) {
                    if (isset($field['default'])) {
                        if (!$settings->getByGroup($groupId, $field['key'])) {
                            $settings->set($groupId, $field['key'], $field['default'], [
                                'type' => $field['type'],
                            ]);
                            $count++;
                            $this->line("Set {$groupId}.{$field['key']} = {$field['default']}");
                        }
                    }
                }
            }
        }

        $this->info("Seeded {$count} default settings.");

        return Command::SUCCESS;
    }
}
