<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class ToggleComingSoonMode extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'coming-soon:toggle {mode? : Enable or disable coming soon mode (on/off)}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Toggle between coming soon mode and normal site mode';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $mode = $this->argument('mode');
        
        if (!$mode) {
            $mode = $this->choice(
                'Select mode',
                ['on' => 'Enable coming soon mode', 'off' => 'Disable coming soon mode'],
                'on'
            );
        }
        
        $routesFile = base_path('routes/web.php');
        $routesContent = File::get($routesFile);
        
        if ($mode === 'on') {
            // Enable coming soon mode
            $pattern = '/\/\/ Coming Soon Page.*\n\s*?Route::get\(\'\\/\',.*?name\(\'coming-soon\'\)\);/s';
            $replacement = "// Coming Soon Page - Uncomment to enable\n    Route::get('/', [ComingSoonController::class, 'index'])->name('coming-soon');";
            
            $routesContent = preg_replace($pattern, $replacement, $routesContent);
            
            $pattern = '/\/\/ Regular Home Page.*?\}\)->name\(\'home\'\);/s';
            $replacement = "// Regular Home Page - Comment to enable coming soon\n    // Route::get('/', function () {\n    //     \$homePageSlug = 'home';\n    //     \$homePage = Page::where('slug', \$homePageSlug)->first();\n    //     if(\$homePage) {\n    //         return App::call('App\Http\Controllers\Frontend\TemplateController@index', ['slug' => \$homePageSlug]);\n    //     } else {\n    //         // return redirect()->route('blog.index');\n    //         return App::call('App\Http\Controllers\Frontend\HomeController@index');\n    //     }\n    // })->name('home');";
            
            $routesContent = preg_replace($pattern, $replacement, $routesContent);
            
            File::put($routesFile, $routesContent);
            $this->info('Coming soon mode enabled.');
        } else {
            // Disable coming soon mode
            $pattern = '/\/\/ Coming Soon Page.*\n\s*?Route::get\(\'\\/\',.*?name\(\'coming-soon\'\)\);/s';
            $replacement = "// Coming Soon Page - Uncomment to enable\n    // Route::get('/', [ComingSoonController::class, 'index'])->name('coming-soon');";
            
            $routesContent = preg_replace($pattern, $replacement, $routesContent);
            
            $pattern = '/\/\/ Regular Home Page.*?\}\)->name\(\'home\'\);/s';
            $replacement = "// Regular Home Page - Comment to enable coming soon\n    Route::get('/', function () {\n        \$homePageSlug = 'home';\n        \$homePage = Page::where('slug', \$homePageSlug)->first();\n        if(\$homePage) {\n            return App::call('App\Http\Controllers\Frontend\TemplateController@index', ['slug' => \$homePageSlug]);\n        } else {\n            // return redirect()->route('blog.index');\n            return App::call('App\Http\Controllers\Frontend\HomeController@index');\n        }\n    })->name('home');";
            
            $routesContent = preg_replace($pattern, $replacement, $routesContent);
            
            File::put($routesFile, $routesContent);
            $this->info('Coming soon mode disabled. Normal site mode activated.');
        }
        
        // Clear route cache
        $this->call('route:clear');
        
        return Command::SUCCESS;
    }
}
