<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        \App\Console\Commands\ImportCompaniesCommand::class,
        \App\Console\Commands\GenerateUserUuids::class,
        \App\Console\Commands\UpdateJobsDataCommand::class,
        \App\Console\Commands\CreateServiceUserSubscriptions::class,
    ];

    protected function schedule(Schedule $schedule): void
    {
        // Run every 30 minutes
        $schedule->command('posts:publish-scheduled')
            ->everyThirtyMinutes()
            ->withoutOverlapping(); // Prevents multiple instances running simultaneously
    }
}
