<?php

namespace App\DTOs\ApiClient;

use App\Models\ApiClient;

class ApiClientDTO
{
    public int $id;
    public string $name;
    public string $type;
    public bool $is_active;
    public ?int $created_by;
    public string $created_at;
    public string $updated_at;

    // Relationships
    public ?array $creator;
    public ?int $tokens_count;

    public function __construct(ApiClient $apiClient, bool $includeRelations = false)
    {
        $this->id = $apiClient->id;
        $this->name = $apiClient->name;
        $this->type = $apiClient->type;
        $this->is_active = $apiClient->is_active;
        $this->created_by = $apiClient->created_by;
        $this->created_at = $apiClient->created_at->toIso8601String();
        $this->updated_at = $apiClient->updated_at->toIso8601String();

        if ($includeRelations) {
            $this->creator = $apiClient->creator ? [
                'id' => $apiClient->creator->id,
                'name' => $apiClient->creator->name,
                'email' => $apiClient->creator->email,
            ] : null;

            $this->tokens_count = $apiClient->tokens()->count();
        }
    }

    public function toArray(): array
    {
        $data = [
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            'is_active' => $this->is_active,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];

        if (isset($this->creator)) {
            $data['creator'] = $this->creator;
        }
        if (isset($this->tokens_count)) {
            $data['tokens_count'] = $this->tokens_count;
        }

        return $data;
    }
}
