<?php

namespace App\DTOs\ApiClient;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

class GenerateTokenDTO
{
    public string $token_name;
    public array $abilities;

    public function __construct(array $data)
    {
        $this->token_name = $data['token_name'];
        $this->abilities = $data['abilities'] ?? ['*'];
    }

    public static function fromRequest(Request $request): self
    {
        $validated = $request->validate(self::rules());
        return new self($validated);
    }

    public static function fromArray(array $data): self
    {
        $validator = Validator::make($data, self::rules());

        if ($validator->fails()) {
            throw new ValidationException($validator);
        }

        return new self($validator->validated());
    }

    /**
     * Get validation rules
     */
    protected static function rules(): array
    {
        $validAbilities = [
            '*',
            'leads:read',
            'leads:create',
            'leads:update',
            'leads:delete',
            'forms:read',
            'forms:create',
            'forms:update',
            'forms:delete',
        ];

        return [
            'token_name' => 'required|string|max:255',
            'abilities' => 'sometimes|array',
            'abilities.*' => [
                'string',
                Rule::in($validAbilities)
            ],
        ];
    }

    public function toArray(): array
    {
        return [
            'token_name' => $this->token_name,
            'abilities' => $this->abilities,
        ];
    }

    public function getTokenName(): string
    {
        return $this->token_name;
    }

    public function getAbilities(): array
    {
        return $this->abilities;
    }
}
