<?php

namespace App\DTOs\Lead\FieldLeadForm;

use App\Models\Lead\FieldLeadForm;

class FieldLeadFormDTO
{
    public int $id;
    public int $lead_form_id;
    public int $field_id;
    public ?string $field_placeholder;
    public ?string $toggle_yes_text;
    public ?string $toggle_no_text;
    public ?int $field_columns;
    public ?string $help_text;
    public ?array $field_options;
    public bool $is_required;
    public bool $is_visible;
    public int $field_order;

    // Relationships
    public ?array $lead_form;
    public ?array $field;

    public function __construct(FieldLeadForm $fieldLeadForm, bool $includeRelations = false)
    {
        $this->id = $fieldLeadForm->id;
        $this->lead_form_id = $fieldLeadForm->lead_form_id;
        $this->field_id = $fieldLeadForm->field_id;
        $this->field_placeholder = $fieldLeadForm->field_placeholder;
        $this->toggle_yes_text = $fieldLeadForm->toggle_yes_text;
        $this->toggle_no_text = $fieldLeadForm->toggle_no_text;
        $this->field_columns = $fieldLeadForm->field_columns;
        $this->help_text = $fieldLeadForm->help_text;
        $this->field_options = $fieldLeadForm->field_options;
        $this->is_required = $fieldLeadForm->is_required ?? false;
        $this->is_visible = $fieldLeadForm->is_visible ?? true;
        $this->field_order = $fieldLeadForm->field_order ?? 0;

        if ($includeRelations) {
            $this->lead_form = $fieldLeadForm->leadForm ? [
                'id' => $fieldLeadForm->leadForm->id,
                'uuid' => $fieldLeadForm->leadForm->uuid,
                'title' => $fieldLeadForm->leadForm->title,
            ] : null;

            $this->field = $fieldLeadForm->field ? [
                'id' => $fieldLeadForm->field->id,
                'uuid' => $fieldLeadForm->field->uuid,
                'field_name' => $fieldLeadForm->field->field_name,
                'field_id' => $fieldLeadForm->field->field_id,
                'field_type' => $fieldLeadForm->field->field_type?->value,
                'data_type' => $fieldLeadForm->field->data_type?->value,
            ] : null;
        }
    }

    public function toArray(): array
    {
        $data = [
            'id' => $this->id,
            'lead_form_id' => $this->lead_form_id,
            'field_id' => $this->field_id,
            'field_placeholder' => $this->field_placeholder,
            'toggle_yes_text' => $this->toggle_yes_text,
            'toggle_no_text' => $this->toggle_no_text,
            'field_columns' => $this->field_columns,
            'help_text' => $this->help_text,
            'field_options' => $this->field_options,
            'is_required' => $this->is_required,
            'is_visible' => $this->is_visible,
            'field_order' => $this->field_order,
        ];

        if (isset($this->lead_form)) {
            $data['lead_form'] = $this->lead_form;
        }
        if (isset($this->field)) {
            $data['field'] = $this->field;
        }

        return $data;
    }

    public function hasOptions(): bool
    {
        return !empty($this->field_options);
    }

    public function isToggleField(): bool
    {
        return $this->toggle_yes_text !== null || $this->toggle_no_text !== null;
    }
}
