<?php

namespace App\DTOs\Lead\FieldLeadForm;

use Illuminate\Http\Request;

class UpdateFieldLeadFormDTO
{
    public ?string $field_placeholder;
    public ?string $toggle_yes_text;
    public ?string $toggle_no_text;
    public ?int $field_columns;
    public ?string $help_text;
    public ?array $field_options;
    public ?bool $is_required;
    public ?bool $is_visible;
    public ?int $field_order;

    public function __construct(array $data)
    {
        $this->field_placeholder = $data['field_placeholder'] ?? null;
        $this->toggle_yes_text = $data['toggle_yes_text'] ?? null;
        $this->toggle_no_text = $data['toggle_no_text'] ?? null;
        $this->field_columns = $data['field_columns'] ?? null;
        $this->help_text = $data['help_text'] ?? null;
        $this->field_options = $data['field_options'] ?? null;
        $this->is_required = $data['is_required'] ?? null;
        $this->is_visible = $data['is_visible'] ?? null;
        $this->field_order = $data['field_order'] ?? null;
    }

    public static function fromRequest(Request $request): self
    {
        $validated = $request->validate([
            'field_placeholder' => 'sometimes|nullable|string|max:255',
            'toggle_yes_text' => 'sometimes|nullable|string|max:50',
            'toggle_no_text' => 'sometimes|nullable|string|max:50',
            'field_columns' => 'sometimes|nullable|integer|min:1|max:12',
            'help_text' => 'sometimes|nullable|string|max:500',
            'field_options' => 'sometimes|nullable|array',
            'field_options.*' => 'string|max:255',
            'is_required' => 'sometimes|boolean',
            'is_visible' => 'sometimes|boolean',
            'field_order' => 'sometimes|integer|min:0',
        ]);

        return new self($validated);
    }

    public static function fromArray(array $data): self
    {
        return new self($data);
    }

    public function toArray(): array
    {
        $data = [];

        if ($this->field_placeholder !== null) {
            $data['field_placeholder'] = $this->field_placeholder;
        }
        if ($this->toggle_yes_text !== null) {
            $data['toggle_yes_text'] = $this->toggle_yes_text;
        }
        if ($this->toggle_no_text !== null) {
            $data['toggle_no_text'] = $this->toggle_no_text;
        }
        if ($this->field_columns !== null) {
            $data['field_columns'] = $this->field_columns;
        }
        if ($this->help_text !== null) {
            $data['help_text'] = $this->help_text;
        }
        if ($this->field_options !== null) {
            $data['field_options'] = $this->field_options;
        }
        if ($this->is_required !== null) {
            $data['is_required'] = $this->is_required;
        }
        if ($this->is_visible !== null) {
            $data['is_visible'] = $this->is_visible;
        }
        if ($this->field_order !== null) {
            $data['field_order'] = $this->field_order;
        }

        return $data;
    }

    public function hasChanges(): bool
    {
        return !empty($this->toArray());
    }
}
