<?php

namespace App\DTOs\Lead\LeadFormVisit;

use App\Models\Lead\LeadFormVisit;

class LeadFormVisitDTO
{
    public int $id;
    public string $uuid;
    public int $lead_form_id;
    public ?string $source;
    public ?string $unique_identifier;
    public ?string $ip_address;
    public ?string $country;
    public ?string $state;
    public ?string $city;
    public ?string $visit_date;

    // Relationships
    public ?array $lead_form;

    public function __construct(LeadFormVisit $visit, bool $includeRelations = false)
    {
        $this->id = $visit->id;
        $this->uuid = $visit->uuid;
        $this->lead_form_id = $visit->lead_form_id;
        $this->source = $visit->source;
        $this->unique_identifier = $visit->unique_identifier;
        $this->ip_address = $visit->ip_address;
        $this->country = $visit->country;
        $this->state = $visit->state;
        $this->city = $visit->city;
        $this->visit_date = $visit->visit_date;

        if ($includeRelations) {
            $this->lead_form = $visit->leadForm ? [
                'id' => $visit->leadForm->id,
                'uuid' => $visit->leadForm->uuid,
                'title' => $visit->leadForm->title,
            ] : null;
        }
    }

    public function toArray(): array
    {
        $data = [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'lead_form_id' => $this->lead_form_id,
            'source' => $this->source,
            'unique_identifier' => $this->unique_identifier,
            'ip_address' => $this->ip_address,
            'country' => $this->country,
            'state' => $this->state,
            'city' => $this->city,
            'visit_date' => $this->visit_date,
        ];

        if (isset($this->lead_form)) {
            $data['lead_form'] = $this->lead_form;
        }

        return $data;
    }

    public function getFullLocation(): ?string
    {
        $parts = array_filter([
            $this->city,
            $this->state,
            $this->country,
        ]);

        return !empty($parts) ? implode(', ', $parts) : null;
    }
}
