<?php

namespace App\DTOs\Lead\LeadFormVisit;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class UpdateLeadFormVisitDTO
{
    public ?string $source;
    public ?string $unique_identifier;
    public ?string $ip_address;
    public ?string $country;
    public ?string $state;
    public ?string $city;
    public ?string $visit_date;

    public function __construct(array $data)
    {
        $this->source = $data['source'] ?? null;
        $this->unique_identifier = $data['unique_identifier'] ?? null;
        $this->ip_address = $data['ip_address'] ?? null;
        $this->country = $data['country'] ?? null;
        $this->state = $data['state'] ?? null;
        $this->city = $data['city'] ?? null;
        $this->visit_date = $data['visit_date'] ?? null;
    }

    public static function fromRequest(Request $request): self
    {
        $validated = $request->validate(self::rules());
        return new self($validated);
    }

    public static function fromArray(array $data): self
    {
        $validator = Validator::make($data, self::rules());

        if ($validator->fails()) {
            throw new ValidationException($validator);
        }

        return new self($validator->validated());
    }

    /**
     * Get validation rules
     */
    protected static function rules(): array
    {
        return [
            'source' => 'sometimes|string|max:255',
            'unique_identifier' => 'sometimes|string|max:255',
            'ip_address' => 'sometimes|ip',
            'country' => 'sometimes|string|max:255',
            'state' => 'sometimes|string|max:255',
            'city' => 'sometimes|string|max:255',
            'visit_date' => 'sometimes|date',
        ];
    }

    public function toArray(): array
    {
        $data = [];

        if ($this->source !== null) {
            $data['source'] = $this->source;
        }
        if ($this->unique_identifier !== null) {
            $data['unique_identifier'] = $this->unique_identifier;
        }
        if ($this->ip_address !== null) {
            $data['ip_address'] = $this->ip_address;
        }
        if ($this->country !== null) {
            $data['country'] = $this->country;
        }
        if ($this->state !== null) {
            $data['state'] = $this->state;
        }
        if ($this->city !== null) {
            $data['city'] = $this->city;
        }
        if ($this->visit_date !== null) {
            $data['visit_date'] = $this->visit_date;
        }

        return $data;
    }

    public function hasChanges(): bool
    {
        return !empty($this->toArray());
    }
}
