<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum ApiClientType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Website = 'website';
    case Mobile = 'mobile';
    case ThirdParty = 'third-party';
    case Script = 'script';
    case IoT = 'iot';

    public function getLabel(): string
    {
        return match($this) {
            self::Website => 'Website',
            self::Mobile => 'Mobile App',
            self::ThirdParty => 'Third-party Service',
            self::Script => 'Script/CLI',
            self::IoT => 'IoT Device',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Website => 'primary',
            self::Mobile => 'success',
            self::ThirdParty => 'warning',
            self::Script => 'info',
            self::IoT => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Website => 'heroicon-o-globe-alt',
            self::Mobile => 'heroicon-o-device-phone-mobile',
            self::ThirdParty => 'heroicon-o-puzzle-piece',
            self::Script => 'heroicon-o-code-bracket',
            self::IoT => 'heroicon-o-cpu-chip',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Website => 'Web application or website consuming the API',
            self::Mobile => 'Mobile application (iOS, Android) consuming the API',
            self::ThirdParty => 'Third-party service or external integration consuming the API',
            self::Script => 'Command-line script or automated task consuming the API',
            self::IoT => 'IoT device or embedded system consuming the API',
        };
    }

    /**
     * Get all values as an array
     */
    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    /**
     * Get all cases as options array for forms
     */
    public static function options(): array
    {
        $options = [];
        foreach (self::cases() as $case) {
            $options[$case->value] = $case->getLabel();
        }
        return $options;
    }
}
