<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum AppModules: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Leads = 'leads';
    case Classifieds = 'classifieds';
    case Jobs = 'jobs';
    case Blogs = 'blogs';
    case Projects = 'projects';
    case Products = 'products';
    case Inquiries = 'inquiries';
    case Videos = 'videos';
    case Teams = 'teams';
    case Equipment = 'equipment';

    public function getLabel(): string
    {
        return match ($this) {
            self::Leads => 'Leads',
            self::Classifieds => 'Classifieds',
            self::Jobs => 'Jobs',
            self::Blogs => 'Blogs',
            self::Projects => 'Projects',
            self::Products => 'Products',
            self::Inquiries => 'Inquiries',
            self::Videos => 'Videos',
            self::Teams => 'Teams',
            self::Equipment => 'Equipment',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Leads => 'primary',
            self::Classifieds => 'secondary',
            self::Jobs => 'success',
            self::Blogs => 'info',
            self::Projects => 'warning',
            self::Products => 'danger',
            self::Inquiries => 'light',
            self::Videos => 'dark',
            self::Teams => 'primary',
            self::Equipment => 'secondary',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Leads => 'heroicon-o-user',
            self::Classifieds => 'heroicon-o-newspaper',
            self::Jobs => 'heroicon-o-briefcase',
            self::Blogs => 'heroicon-o-book-open',
            self::Projects => 'heroicon-o-building-office',
            self::Products => 'heroicon-o-shopping-bag',
            self::Inquiries => 'heroicon-o-envelope',
            self::Videos => 'heroicon-o-video-camera',
            self::Teams => 'heroicon-o-users',
            self::Equipment => 'heroicon-o-wrench',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Leads => 'Manage leads and their interactions with your business.',
            self::Classifieds => 'Manage classifieds and their interactions with your business.',
            self::Jobs => 'Manage jobs and their interactions with your business.',
            self::Blogs => 'Manage blogs and their interactions with your business.',
            self::Projects => 'Manage projects and their interactions with your business.',
            self::Products => 'Manage products and their interactions with your business.',
            self::Inquiries => 'Manage inquiries and their interactions with your business.',
            self::Videos => 'Manage videos and their interactions with your business.',
            self::Teams => 'Manage teams and their interactions with your business.',
            self::Equipment => 'Manage equipment and their interactions with your business.',
        };
    }
}
