<?php

namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasIcon;

enum BannerTabs: string implements HasLabel, HasIcon
{
    case FindCompany = 'find_company';
    case Jobs = 'jobs';
    case Classifieds = 'classifieds';
    case Manufactures = 'manufactures';
    case Suppliers = 'suppliers';

    public function getLabel(): string
    {
        return match ($this) {
            self::FindCompany => 'Find Company',
            self::Jobs => 'Jobs',
            self::Classifieds => 'Classifieds',
            self::Manufactures => 'Manufactures',
            self::Suppliers => 'Suppliers',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::FindCompany => 'heroicon-o-user',
            self::Jobs => 'heroicon-o-briefcase',
            self::Classifieds => 'heroicon-o-newspaper',
            self::Manufactures => 'heroicon-o-building-office',
            self::Suppliers => 'heroicon-o-building-office',
        };
    }
}