<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasDescription;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;

enum ClassifiedCondition: string implements HasLabel, HasDescription, HasColor, HasIcon
{
    case Used = 'used';
    case New = 'new';
    case LikeNew = 'like_new';
    case Demo = 'demo';
    case Excellent = 'excellent';
    case Good = 'good';
    case Fair = 'fair';
    case AsIs = 'as_is';
    case ForParts = 'for_parts';
    case Refurbished = 'refurbished';
    case Damaged = 'damaged';
    case Project = 'project';
    case CertifiedPreOwned = 'certified_pre_owned';
    case Vintage = 'vintage';
    case Antique = 'antique';

    public function getLabel(): string
    {
        return match ($this) {
            self::Used => 'Used',
            self::New => 'New',
            self::LikeNew => 'Like New',
            self::Demo => 'Demo',
            self::Excellent => 'Excellent',
            self::Good => 'Good',
            self::Fair => 'Fair',
            self::AsIs => 'As Is',
            self::ForParts => 'For Parts',
            self::Refurbished => 'Refurbished',
            self::Damaged => 'Damaged',
            self::Project => 'Project',
            self::CertifiedPreOwned => 'Certified Pre-Owned',
            self::Vintage => 'Vintage',
            self::Antique => 'Antique',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Used => 'danger',
            self::New => 'success',
            self::LikeNew => 'info',
            self::Demo => 'warning',
            self::Excellent => 'success',
            self::Good => 'success',
            self::Fair => 'warning',
            self::AsIs => 'info',
            self::ForParts => 'info',
            self::Refurbished => 'warning',
            self::Damaged => 'danger',
            self::Project => 'info',
            self::CertifiedPreOwned => 'success',
            self::Vintage => 'warning',
            self::Antique => 'success',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Used => 'heroicon-o-arrow-down-tray',
            self::New => 'heroicon-o-arrow-up-tray',
            self::LikeNew => 'heroicon-o-arrow-up-tray',
            self::Demo => 'heroicon-o-arrow-up-tray',
            self::Excellent => 'heroicon-o-arrow-up-tray',
            self::Good => 'heroicon-o-arrow-up-tray',
            self::Fair => 'heroicon-o-arrow-up-tray',
            self::AsIs => 'heroicon-o-arrow-up-tray',
            self::ForParts => 'heroicon-o-arrow-up-tray',
            self::Refurbished => 'heroicon-o-arrow-up-tray',
            self::Damaged => 'heroicon-o-arrow-up-tray',
            self::Project => 'heroicon-o-arrow-up-tray',
            self::CertifiedPreOwned => 'heroicon-o-arrow-up-tray',
            self::Vintage => 'heroicon-o-arrow-up-tray',
            self::Antique => 'heroicon-o-arrow-up-tray',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Used => 'Used Condition',
            self::New => 'New Condition',
            self::LikeNew => 'Like New Condition',
            self::Demo => 'Demo Condition',
            self::Excellent => 'Excellent Condition',
            self::Good => 'Good Condition',
            self::Fair => 'Fair Condition',
            self::AsIs => 'As Is Condition',
            self::ForParts => 'For Parts Condition',
            self::Refurbished => 'Refurbished Condition',
            self::Damaged => 'Damaged Condition',
            self::Project => 'Project Condition',
            self::CertifiedPreOwned => 'Certified Pre-Owned Condition',
            self::Vintage => 'Vintage Condition',
            self::Antique => 'Antique Condition',
        };
    }
}
