<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasDescription;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;

enum ClassifiedLabel: string implements HasLabel, HasDescription, HasColor, HasIcon
{
    case ForSale = 'for-sale';

    public function getLabel(): string
    {
        return match ($this) {
            self::ForSale => 'For Sale',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::ForSale => 'primary',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::ForSale => 'heroicon-o-shopping-cart',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::ForSale => 'For Sale',
        };
    }
}
