<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum ClassifiedStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Published = 'published';
    case Draft = 'draft';
    case Pending = 'pending';
    case Expired = 'expired';
    case Trashed = 'trashed';
    case Scheduled = 'scheduled';

    public function getLabel(): string
    {
        return match ($this) {
            self::Published => 'Published',
            self::Draft => 'Draft',
            self::Pending => 'Pending Review',
            self::Expired => 'Expired',
            self::Trashed => 'Trashed',
            self::Scheduled => 'Scheduled',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Published => 'success',
            self::Draft => 'info',
            self::Pending => 'warning',
            self::Trashed => 'danger',
            self::Expired => 'warning',
            self::Scheduled => 'info',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Published => 'heroicon-o-check-circle',
            self::Draft => 'heroicon-o-pencil',
            self::Pending => 'heroicon-o-clock',
            self::Trashed => 'heroicon-o-trash',
            self::Expired => 'heroicon-o-clock',
            self::Scheduled => 'heroicon-o-clock',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Published => 'The classified is published and visible.',
            self::Draft => 'The classified is a draft and not visible.',
            self::Pending => 'The classified is pending review.',
            self::Expired => 'The classified has expired.',
            self::Trashed => 'The classified has been trashed.',
            self::Scheduled => 'The classified is scheduled for future publication.',
        };
    }
}
