<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasDescription;

enum DateFormat: string implements HasLabel, HasDescription
{
    case YMD = 'Y-m-d';
    case DMY = 'd/m/Y';
    case MDY = 'm/d/Y';

    public function getLabel(): string
    {
        return match ($this) {
            self::YMD => 'YYYY-MM-DD',
            self::DMY => 'DD/MM/YYYY',
            self::MDY => 'MM/DD/YYYY',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::YMD => 'YYYY-MM-DD (2025-01-01)',
            self::DMY => 'DD/MM/YYYY (01/01/2025)',
            self::MDY => 'MM/DD/YYYY (01/01/2025)',
        };
    }
}
