<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasDescription;

enum DayOfWeek: string implements HasLabel, HasDescription
{
    case MONDAY = 'monday';
    case TUESDAY = 'tuesday';
    case WEDNESDAY = 'wednesday';
    case THURSDAY = 'thursday';
    case FRIDAY = 'friday';
    case SATURDAY = 'saturday';
    case SUNDAY = 'sunday';

    public function getLabel(): string
    {
        return match ($this) {
            self::MONDAY => 'Monday',
            self::TUESDAY => 'Tuesday',
            self::WEDNESDAY => 'Wednesday',
            self::THURSDAY => 'Thursday',
            self::FRIDAY => 'Friday',
            self::SATURDAY => 'Saturday',
            self::SUNDAY => 'Sunday',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::MONDAY => 'Monday - Start of the work week',
            self::TUESDAY => 'Tuesday - Second day of the week',
            self::WEDNESDAY => 'Wednesday - Middle of the week',
            self::THURSDAY => 'Thursday - Fourth day of the week',
            self::FRIDAY => 'Friday - End of the work week',
            self::SATURDAY => 'Saturday - Weekend',
            self::SUNDAY => 'Sunday - Weekend',
        };
    }

    public static function getWeekdays(): array
    {
        return [
            self::MONDAY,
            self::TUESDAY,
            self::WEDNESDAY,
            self::THURSDAY,
            self::FRIDAY,
        ];
    }

    public static function getWeekends(): array
    {
        return [
            self::SATURDAY,
            self::SUNDAY,
        ];
    }

    public static function getAllDays(): array
    {
        return [
            self::MONDAY,
            self::TUESDAY,
            self::WEDNESDAY,
            self::THURSDAY,
            self::FRIDAY,
            self::SATURDAY,
            self::SUNDAY,
        ];
    }
}