<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum EquipmentStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Draft = 'draft';
    case Published = 'published';
    case Pending = 'pending';
    case Trashed = 'trashed';
    public function getLabel(): string
    {
        return match ($this) {
            self::Draft => 'Draft',
            self::Published => 'Published',
            self::Pending => 'Pending Review',
            self::Trashed => 'Trashed',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Draft => 'info',
            self::Published => 'success',
            self::Pending => 'warning',
            self::Trashed => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Draft => 'heroicon-o-pencil',
            self::Published => 'heroicon-o-check-circle',
            self::Pending => 'heroicon-o-clock',
            self::Trashed => 'heroicon-o-trash',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Draft => 'The equipment is a draft and not visible to others.',
            self::Published => 'The equipment is published and visible to all users.',
            self::Pending => 'The equipment is pending review before publication.',
            self::Trashed => 'The equipment is trashed and not visible to others.',
        };
    }
}
