<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum FieldDataSource: string implements HasColor, HasDescription, HasIcon, HasLabel
{
    case List = 'list';
    case Enum = 'enum';

    public function getLabel(): string
    {
        return match ($this) {
            self::List => 'Manual List',
            self::Enum => 'Enum Class',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::List => 'info',
            self::Enum => 'success',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::List => 'heroicon-o-list-bullet',
            self::Enum => 'heroicon-o-code-bracket',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::List => 'Define options manually using key-value pairs',
            self::Enum => 'Use options from an Enum class',
        };
    }
}
