<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum InquiryStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Contacted = 'contacted';
    case Pending = 'pending';

    public function getLabel(): string
    {
        return match ($this) {
            self::Contacted => 'Contacted',
            self::Pending => 'Pending',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Contacted => 'success',
            self::Pending => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Contacted => 'heroicon-o-envelope',
            self::Pending => 'heroicon-o-clock',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Contacted => 'The inquiry has been contacted.',
            self::Pending => 'The inquiry is pending.',
        };
    }
}
