<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum InquiryType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Profile = 'profile';
    case Classified = 'classified';
    case Jobs = 'jobs';
    case Contact = 'contact';
    case Product = 'product';
    case Article = 'article';
    case Other = 'other';

    public function getLabel(): string
    {
        return match ($this) {
            self::Profile => 'Profile Inquiry',
            self::Classified => 'Classified Inquiry',
            self::Jobs => 'Jobs Inquiry',
            self::Contact => 'Contact Inquiry',
            self::Product => 'Product Inquiry',
            self::Article => 'Article Inquiry',
            self::Other => 'Other Inquiry',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Profile => 'info',
            self::Classified => 'warning',
            self::Jobs => 'success',
            self::Contact => 'danger',
            self::Product => 'info',
            self::Article => 'info',
            self::Other => 'info',
        };
    }

    public function getTailwindColor(): string
    {
        return match ($this) {
            self::Profile => 'blue',
            self::Classified => 'yellow',
            self::Jobs => 'green',
            self::Contact => 'red',
            self::Product => 'blue',
            self::Article => 'blue',
            self::Other => 'gray',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Profile => 'heroicon-o-user',
            self::Classified => 'heroicon-o-briefcase',
            self::Jobs => 'heroicon-o-briefcase',
            self::Contact => 'heroicon-o-phone',
            self::Product => 'heroicon-o-shopping-bag',
            self::Article => 'heroicon-o-book-open',
            self::Other => 'heroicon-o-question-mark-circle',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Profile => 'Inquiry about a profile.',
            self::Classified => 'Inquiry about a classified.',
            self::Jobs => 'Inquiry about jobs.',
            self::Contact => 'Inquiry about contact information.',
            self::Product => 'Inquiry about a product.',
            self::Article => 'Inquiry about an article.',
            self::Other => 'Inquiry about something else.',
        };
    }
}
