<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum JobApplicationStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Pending = 'pending';
    case Shortlisted = 'shortlisted';
    case Rejected = 'rejected';
    case Hired = 'hired';

    public function getLabel(): string
    {
        return match($this) {
            self::Pending => 'Pending',
            self::Shortlisted => 'Shortlisted',
            self::Rejected => 'Rejected',
            self::Hired => 'Hired',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Pending => 'info',
            self::Shortlisted => 'warning',
            self::Rejected => 'danger',
            self::Hired => 'success',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Pending => 'heroicon-o-paper-airplane',
            self::Shortlisted => 'heroicon-o-list-bullet',
            self::Rejected => 'heroicon-o-x-circle',
            self::Hired => 'heroicon-o-check-circle',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Pending => 'Application submitted and pending review',
            self::Shortlisted => 'Candidate selected for further consideration',
            self::Rejected => 'Application was not successful',
            self::Hired => 'Candidate has been selected and hired',
        };
    }
} 