<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum JobGender: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Male = 'male';
    case Female = 'female';

    public function getLabel(): string
    {
        return match($this) {
            self::Male => 'Male',
            self::Female => 'Female',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Male => 'info',
            self::Female => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Male => 'heroicon-o-user',
            self::Female => 'heroicon-o-user-circle',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Male => 'Male',
            self::Female => 'Female',
        };
    }
} 