<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;

enum JobPostedDateEnum: string implements HasLabel, HasDescription

{
    case POSTED_TODAY = '1';
    case LAST_3_DAYS = '3';
    case LAST_7_DAYS = '7';
    case LAST_MONTH = '30';

    public function getLabel(): string
    {
        return match ($this) {
            self::POSTED_TODAY => 'Posted Today',
            self::LAST_3_DAYS => 'Last 3 Days',
            self::LAST_7_DAYS => 'Last 7 Days',
            self::LAST_MONTH => 'Last Month',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::POSTED_TODAY => 'Posted Today',
            self::LAST_3_DAYS => 'Last 3 Days',
            self::LAST_7_DAYS => 'Last 7 Days',
            self::LAST_MONTH => 'Last Month',
        };
    }
}
