<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum JobSalaryPeriod: string implements HasLabel, HasColor, HasIcon, HasDescription 
{
    case Daily = 'daily';
    case Weekly = 'weekly';
    case Monthly = 'monthly';
    case Yearly = 'yearly';

    public function getLabel(): string
    {
        return match($this) {
            self::Daily => 'Daily',
            self::Weekly => 'Weekly',
            self::Monthly => 'Monthly',
            self::Yearly => 'Yearly',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Daily => 'info',
            self::Weekly => 'warning',
            self::Monthly => 'success',
            self::Yearly => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Daily => 'heroicon-o-clock',
            self::Weekly => 'heroicon-o-calendar-days',
            self::Monthly => 'heroicon-o-calendar-month',
            self::Yearly => 'heroicon-o-calendar-year',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Daily => 'Daily',
            self::Weekly => 'Weekly',
            self::Monthly => 'Monthly',
            self::Yearly => 'Yearly',
        };
    }
} 