<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum JobShift: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Morning = 'morning';
    case Noon = 'noon';
    case Evening = 'evening';
    case Night = 'night';

    public function getLabel(): string
    {
        return match ($this) {
            self::Morning => 'Morning Shift',
            self::Noon => 'Noon Shift',
            self::Evening => 'Evening Shift',
            self::Night => 'Night Shift',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Morning => 'warning',
            self::Noon => 'success',
            self::Evening => 'info',
            self::Night => 'gray',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Morning => 'heroicon-o-sun',
            self::Noon => 'heroicon-o-sun',
            self::Evening => 'heroicon-o-moon',
            self::Night => 'heroicon-o-moon',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Morning => 'Early morning shift (typically 6 AM - 2 PM)',
            self::Noon => 'Day shift (typically 9 AM - 5 PM)',
            self::Evening => 'Evening shift (typically 2 PM - 10 PM)',
            self::Night => 'Night shift (typically 10 PM - 6 AM)',
        };
    }
}
