<?php

namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum JobStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Draft = 'draft';
    case Published = 'published';
    case Pending = 'pending';
    case Expired = 'expired';
    case Trashed = 'trashed';
    case Scheduled = 'scheduled';

    public function getLabel(): string
    {
        return match($this) {
            self::Draft => 'Draft',
            self::Published => 'Published',
            self::Pending => 'Pending Review',
            self::Expired => 'Expired',
            self::Trashed => 'Trashed',
            self::Scheduled => 'Scheduled',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Published => 'success',
            self::Draft => 'info',
            self::Pending => 'warning',
            self::Trashed => 'danger',
            self::Expired => 'warning',
            self::Scheduled => 'info',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Published => 'heroicon-o-check-circle',
            self::Draft => 'heroicon-o-pencil',
            self::Pending => 'heroicon-o-clock',
            self::Trashed => 'heroicon-o-trash',
            self::Expired => 'heroicon-o-clock',
            self::Scheduled => 'heroicon-o-clock',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Draft => 'Not yet published',
            self::Published => 'Visible to job seekers',
            self::Pending => 'Awaiting review',
            self::Expired => 'Past deadline',
            self::Trashed => 'Moved to trash',
            self::Scheduled => 'Scheduled for future publication',
        };
    }
}
