<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum JobWorkMode: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Remote = 'remote';
    case Hybrid = 'hybrid';
    case Onsite = 'onsite';

    public function getLabel(): string
    {
        return match ($this) {
            self::Remote => 'Remote',
            self::Hybrid => 'Hybrid',
            self::Onsite => 'Onsite',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Remote => 'primary',
            self::Hybrid => 'secondary',
            self::Onsite => 'success',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Remote => 'heroicon-o-globe',
            self::Hybrid => 'heroicon-o-globe',
            self::Onsite => 'heroicon-o-globe',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Remote => 'Remote',
            self::Hybrid => 'Hybrid',
            self::Onsite => 'Onsite',
        };
    }
}
