<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum LeadFormFieldDataType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case AlphaNumeric = 'alpha_numeric';
    case Phone = 'phone';
    case Number = 'number';
    case Email = 'email';
    case Link = 'link';
    case SubmitButton = 'submit_button';

    public function getLabel(): string
    {
        return match($this) {
            self::AlphaNumeric => 'Alpha Numeric',
            self::Phone => 'Phone',
            self::Number => 'Number',
            self::Email => 'Email',
            self::Link => 'Link',
            self::SubmitButton => 'Submit Button',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::AlphaNumeric => 'info',
            self::Phone => 'warning',
            self::Number => 'success',
            self::Email => 'info',
            self::Link => 'warning',
            self::SubmitButton => 'info',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::AlphaNumeric => 'heroicon-o-pencil',
            self::Phone => 'heroicon-o-phone',
            self::Number => 'heroicon-o-hashtag',
            self::Email => 'heroicon-o-envelope',
            self::Link => 'heroicon-o-link',
            self::SubmitButton => 'heroicon-o-arrow-right',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::AlphaNumeric => 'Alpha Numeric',
            self::Phone => 'Phone',
            self::Number => 'Number',
            self::Email => 'Email',
            self::Link => 'Link',
            self::SubmitButton => 'Submit Button',
        };
    }

} 