<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum LeadFormFieldType: string implements HasColor, HasDescription, HasIcon, HasLabel
{
    case Select = 'select';
    case Toggle = 'toggle';
    case Checkbox = 'checkbox';
    case Phone = 'phone';
    case Radio = 'radio';
    case Number = 'number';
    case Text = 'text';
    case Textarea = 'textarea';
    case File = 'file';
    case Hidden = 'hidden';
    case Geolocation = 'geolocation';
    case SectionTitle = 'section_title';
    case Email = 'email';
    case SubmitButton = 'submit_button';
    case LineSeparator = 'line_separator';

    public function getLabel(): string
    {
        return match ($this) {
            self::Select => 'Select',
            self::Toggle => 'Toggle',
            self::Checkbox => 'Checkbox',
            self::Phone => 'Phone',
            self::Radio => 'Radio',
            self::Number => 'Number',
            self::Text => 'Text',
            self::Textarea => 'Textarea',
            self::File => 'File',
            self::Hidden => 'Hidden',
            self::Geolocation => 'Geolocation',
            self::SectionTitle => 'Section Title',
            self::Email => 'Email',
            self::SubmitButton => 'Submit Button',
            self::LineSeparator => 'Line Separator',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Select => 'info',
            self::Toggle => 'warning',
            self::Checkbox => 'success',
            self::Phone => 'info',
            self::Radio => 'danger',
            self::Number => 'info',
            self::Text => 'info',
            self::Textarea => 'warning',
            self::File => 'success',
            self::Hidden => 'danger',
            self::Geolocation => 'info',
            self::SectionTitle => 'warning',
            self::Email => 'info',
            self::SubmitButton => 'info',
            self::LineSeparator => 'info',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Select => 'heroicon-o-chevron-down',
            self::Toggle => 'heroicon-o-arrows-right-left',
            self::Checkbox => 'heroicon-o-check-circle',
            self::Phone => 'heroicon-o-phone',
            self::Radio => 'heroicon-o-circle-stack',
            self::Number => 'heroicon-o-hashtag',
            self::Text => 'heroicon-o-pencil',
            self::Textarea => 'heroicon-o-pencil',
            self::File => 'heroicon-o-photo',
            self::Hidden => 'heroicon-o-eye-slash',
            self::Geolocation => 'heroicon-o-map-pin',
            self::SectionTitle => '',
            self::Email => 'heroicon-o-envelope',
            self::SubmitButton => '',
            self::LineSeparator => '',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::SectionTitle => 'Section Title',
            self::Select => 'Select',
            self::Toggle => 'Toggle',
            self::Checkbox => 'Checkbox',
            self::Phone => 'Phone',
            self::Radio => 'Radio',
            self::Number => 'Number',
            self::Text => 'Text',
            self::Textarea => 'Textarea',
            self::File => 'File',
            self::Hidden => 'Hidden',
            self::Geolocation => 'Geolocation',
            self::Email => 'Email',
            self::LineSeparator => 'Line Separator',
        };
    }
}
