<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum LeadFormLayout: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Simple = 'simple';
    case Wizard = 'wizard';

    public function getLabel(): string
    {
        return match($this) {
            self::Simple => 'Simple',
            self::Wizard => 'Wizard',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Simple => 'info',
            self::Wizard => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Simple => 'heroicon-o-rectangle-stack',
            self::Wizard => 'heroicon-o-sparkles',
        };
    }

    
    public function getDescription(): string
    {
        return match($this) {
            self::Simple => 'Single-page form',
            self::Wizard => 'Multi-step wizard form',
        };
    }
}


