<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum LeadFormMatchCriteria: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Category = 'category';
    case CategoryLocation = 'category_location';

    public function getLabel(): string
    {
        return match($this) {
            self::Category => 'Category',
            self::CategoryLocation => 'Category and Location',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Category => 'info',
            self::CategoryLocation => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Category => 'heroicon-o-tag',
            self::CategoryLocation => 'heroicon-o-map-pin',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Category => 'Match leads to categories',
            self::CategoryLocation => 'Match leads to categories and locations',
        };
    }
} 