<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum LeadFormReceptionMode: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Auto = 'auto';
    case Manual = 'manual';

    public function getLabel(): string
    {
        return match($this) {
            self::Auto => 'Auto',
            self::Manual => 'Manual',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Auto => 'info',
            self::Manual => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Auto => 'heroicon-o-check-circle',
            self::Manual => 'heroicon-o-hand-thumb-up',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Auto => 'Automatically receive leads',
            self::Manual => 'Manually receive leads',
        };
    }
} 