<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum LeadStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Pending = 'pending';
    case FollowUp = 'follow-up';
    case SoldOut = 'sold-out';
    case Closed = 'closed';
    case BadLead = 'bad-lead';
    case Duplicate = 'duplicate';
    case Trashed = 'trashed';

    public function getLabel(): string
    {
        return match($this) {
            self::Pending => 'Pending',
            self::FollowUp => 'Follow Up',
            self::SoldOut => 'Sold Out',
            self::Closed => 'Closed',
            self::BadLead => 'Bad Lead',
            self::Duplicate => 'Duplicate',
            self::Trashed => 'Trashed',
        };
    }

    public function getColor(): string 
    {
        return match($this) {
            self::Pending => 'warning',
            self::FollowUp => 'primary',
            self::SoldOut => 'success',
            self::Closed => 'danger',
            self::BadLead => 'gray',
            self::Duplicate => 'info',
            self::Trashed => 'gray',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Pending => 'heroicon-o-clock',
            self::FollowUp => 'heroicon-o-arrow-path',
            self::SoldOut => 'heroicon-o-banknotes',
            self::Closed => 'heroicon-o-archive-box',
            self::BadLead => 'heroicon-o-x-circle',
            self::Duplicate => 'heroicon-o-document-duplicate',
            self::Trashed => 'heroicon-o-trash',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Pending => 'Inquiry about a pending lead.',
            self::FollowUp => 'Inquiry about a follow up lead.',
            self::SoldOut => 'Inquiry about a sold out lead.',
            self::Closed => 'Inquiry about a closed lead.',
            self::BadLead => 'Inquiry about a bad lead.',
            self::Duplicate => 'Inquiry about a duplicate lead.',
            self::Trashed => 'Inquiry about a trashed lead.',
        };
    }
} 