<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum LeadUserStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case New = 'new';
    case InProgress = 'in_progress';
    case Contacted = 'contacted';
    case Qualified = 'qualified';
    case Converted = 'converted';
    case Lost = 'lost';
    case OnHold = 'on_hold';
    case FollowUp = 'follow-up';
    case Pending = 'pending';
    case Rejected = 'rejected';
    case Closed = 'closed';

    public function getLabel(): string
    {
        return match($this) {
            self::New => 'New',
            self::InProgress => 'In Progress',
            self::Contacted => 'Contacted',
            self::Qualified => 'Qualified',
            self::Converted => 'Converted',
            self::Lost => 'Lost',
            self::OnHold => 'On Hold',
            self::FollowUp => 'Follow Up',
            self::Pending => 'Pending',
            self::Rejected => 'Rejected',
            self::Closed => 'Closed',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::New => 'info',
            self::InProgress => 'warning',
            self::Contacted => 'primary',
            self::Qualified => 'success',
            self::Converted => 'success',
            self::Lost => 'danger',
            self::OnHold => 'gray',
            self::FollowUp => 'warning',
            self::Pending => 'gray',
            self::Rejected => 'danger',
            self::Closed => 'gray',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::New => 'heroicon-o-sparkles',
            self::InProgress => 'heroicon-o-arrow-path',
            self::Contacted => 'heroicon-o-chat-bubble-left-ellipsis',
            self::Qualified => 'heroicon-o-check-circle',
            self::Converted => 'heroicon-o-trophy',
            self::Lost => 'heroicon-o-x-circle',
            self::OnHold => 'heroicon-o-pause-circle',
            self::FollowUp => 'heroicon-o-arrow-path',
            self::Pending => 'heroicon-o-clock',
            self::Rejected => 'heroicon-o-x-mark',
            self::Closed => 'heroicon-o-x-mark',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::New => 'The lead is new and has not been contacted yet',
            self::InProgress => 'The lead is in progress and being contacted',
            self::Contacted => 'The lead has been contacted',
            self::Qualified => 'The lead has been qualified',
            self::Converted => 'The lead has been converted',
            self::Lost => 'The lead has been lost',
            self::OnHold => 'The lead is on hold',
            self::FollowUp => 'The lead needs to be followed up',
            self::Pending => 'The lead is pending',
            self::Rejected => 'The lead has been rejected',
            self::Closed => 'The lead has been closed',
            };
    }
} 
