<?php

namespace App\Enums;

use Filament\Support\Contracts\HasDescription;
use Filament\Support\Contracts\HasLabel;

enum MemberRatingType: string implements HasLabel, HasDescription
{
    case ServiceQuality = 'service_quality';
    case ResponseTime = 'response_time';
    case ValueForMoney = 'value_for_money';
    case Professionalism = 'professionalism';
    case Communication = 'communication';

    public function getLabel(): string
    {
        return match ($this) {
            self::ServiceQuality => 'Service Quality',
            self::ResponseTime => 'Response Time',
            self::ValueForMoney => 'Value for Money',
            self::Professionalism => 'Professionalism',
            self::Communication => 'Communication',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::ServiceQuality => 'Overall quality of the service',
            self::ResponseTime => 'How fast they responded',
            self::ValueForMoney => 'Was the service worth it?',
            self::Professionalism => 'Were they skilled and courteous?',
            self::Communication => 'Clarity and effectiveness of communication',
        };
    }
}
