<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum MemberType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Member = 'member';
    case Supplier = 'supplier';

    public function getLabel(): string
    {
        return match($this) {
            self::Member => 'Member',
            self::Supplier => 'Supplier',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Member => 'info',
            self::Supplier => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Member => 'heroicon-o-user',
            self::Supplier => 'heroicon-o-briefcase',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Member => 'Member of the ESP',
            self::Supplier => 'Supplier of the ESP',
        };
    }
} 