<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum MembershipPaymentTerm: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Monthly = 'monthly';
    case Quarterly = 'quarterly';
    case SemiYearly = 'semi-yearly';
    case Yearly = 'yearly';

    public function getLabel(): string
    {
        return match ($this) {
            self::Monthly => 'Monthly',
            self::Quarterly => 'Quarterly',
            self::SemiYearly => 'Semi Yearly',
            self::Yearly => 'Yearly',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Monthly => 'info',
            self::Quarterly => 'warning',
            self::SemiYearly => 'success',
            self::Yearly => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Monthly => 'heroicon-o-calendar-days',
            self::Quarterly => 'heroicon-o-calendar-days',
            self::SemiYearly => 'heroicon-o-calendar-days',
            self::Yearly => 'heroicon-o-calendar-days',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Monthly => 'Payment is due monthly',
            self::Quarterly => 'Payment is due quarterly',
            self::SemiYearly => 'Payment is due semi-yearly',
            self::Yearly => 'Payment is due yearly',
        };
    }
}
